/*
 * @brief LPC800 sct fsm header file
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */


#ifndef __SCT_FSM_H__
#define __SCT_FSM_H__

/* Generated by fzmparser version 2.4 --- DO NOT EDIT! */

#include "sct_user.h"


/* Input assignments */
#define SCT_INPUT_DATA (0)

/* Output assignments (and their defaults if specified) */
#define SCT_OUTPUT_LED (0)
#define SCT_OUTPUTPRELOAD_LED (0)

#define SCT_setOutputDefault() do {LPC_SCT->OUTPUT = (LPC_SCT->OUTPUT & ~0x00000001) | 0x00000000;} while(0)


/* Match register reload macro definitions */
#define reload_match_duty_cycle(value) do {LPC_SCT->MATCHREL_L[0] = value;} while(0)
#define reload_match_pulse_period(value) do {LPC_SCT->MATCHREL_L[1] = value;} while(0)

#ifdef __cplusplus
extern "C" {
#endif

extern void sct_fsm_init (void);

#ifdef __cplusplus
}
#endif

#endif /* __SCT_FSM_H_ */

